/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.Modifier.Base;

import com.hoshino.cti.Modifier.capability.PressurizableToolCap;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ValidateModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.VolatileDataModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class PressurizableModifier
extends Modifier
implements VolatileDataModifierHook,
ModifierRemovalHook,
TooltipModifierHook,
ValidateModifierHook {
    protected void registerHooks(ModuleHookMap.Builder builder) {
        super.registerHooks(builder);
        builder.addHook((Object)this, new ModuleHook[]{ModifierHooks.VOLATILE_DATA, ModifierHooks.REMOVE, ModifierHooks.TOOLTIP, ModifierHooks.VALIDATE});
    }

    public void addVolatileData(IToolContext iToolContext, ModifierEntry modifierEntry, ModDataNBT modDataNBT) {
        if (modDataNBT.contains(PressurizableToolCap.BASE_VOLUME_KEY, 3)) {
            modDataNBT.putInt(PressurizableToolCap.BASE_VOLUME_KEY, modDataNBT.getInt(PressurizableToolCap.BASE_VOLUME_KEY) + this.getBaseVolume(modifierEntry));
        } else {
            modDataNBT.putInt(PressurizableToolCap.BASE_VOLUME_KEY, this.getBaseVolume(modifierEntry));
        }
        if (modDataNBT.contains(PressurizableToolCap.MAX_PRESSURE_KEY, 3)) {
            modDataNBT.putFloat(PressurizableToolCap.MAX_PRESSURE_KEY, (float)modDataNBT.getInt(PressurizableToolCap.MAX_PRESSURE_KEY) + this.getMaxPressure(modifierEntry));
        } else {
            modDataNBT.putFloat(PressurizableToolCap.MAX_PRESSURE_KEY, this.getMaxPressure(modifierEntry));
        }
    }

    public int getBaseVolume(ModifierEntry entry) {
        return 10000;
    }

    public float getMaxPressure(ModifierEntry entry) {
        return 20.0f;
    }

    @Nullable
    public Component onRemoved(IToolStackView iToolStackView, Modifier modifier) {
        if (iToolStackView.getVolatileData().getInt(PressurizableToolCap.BASE_VOLUME_KEY) <= 0) {
            iToolStackView.getPersistentData().remove(PressurizableToolCap.AIR_KEY);
        }
        return null;
    }

    public void addTooltip(IToolStackView tool, ModifierEntry modifierEntry, @Nullable Player player, List<Component> list, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        list.add((Component)Component.m_237115_((String)"cti.tooltip.modifier.volume").m_130946_(":").m_130946_(" " + tool.getVolatileData().getInt(PressurizableToolCap.BASE_VOLUME_KEY) + "mL"));
        list.add((Component)Component.m_237115_((String)"cti.tooltip.modifier.air").m_130946_(":").m_130946_(" " + tool.getPersistentData().getInt(PressurizableToolCap.AIR_KEY) + "mL"));
        list.add((Component)Component.m_237115_((String)"cti.tooltip.modifier.pressure").m_130946_(":").m_130946_(" " + String.format("%.1f", Float.valueOf((float)tool.getPersistentData().getInt(PressurizableToolCap.AIR_KEY) / (float)tool.getVolatileData().getInt(PressurizableToolCap.BASE_VOLUME_KEY))) + "/" + String.format("%.1f", Float.valueOf(tool.getVolatileData().getFloat(PressurizableToolCap.MAX_PRESSURE_KEY))) + "bar"));
    }

    @Nullable
    public Component validate(IToolStackView tool, ModifierEntry modifierEntry) {
        if ((float)PressurizableToolCap.getAir(tool) > PressurizableToolCap.getMaxPressure(tool) * (float)PressurizableToolCap.getBaseVolume(tool)) {
            PressurizableToolCap.addAir(tool, (int)(PressurizableToolCap.getMaxPressure(tool) * (float)PressurizableToolCap.getBaseVolume(tool) - (float)PressurizableToolCap.getAir(tool)));
        }
        return null;
    }
}

